\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Once in royal David's city"
  subtitle = " "
  %subsubtitle = "Op. 19"
  poet = "C. F. Alexander (1818 - 1895)"
  composer = "H. J. Gauntlett (1805 - 1876)"
  %arranger = "io"
  %meter = "nu prea încet"
  tagline=""
}

global = {
  \key g \major
  \autoBeamOff
  %\cadenzaOn
  \time 4/4
  %\partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Once in ro -- yal Da -- vid's ci -- ty
  Stood a low -- ly cat -- tle __ shed,
  Ma -- ry was that mo -- ther mild,
  Je -- sus Christ her lit -- tle child.
}

womenWordsOneR = \lyricmode {
  Where a mo -- ther laid her ba -- by
  In a man -- ger for His __ bed.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  He came down to earth from hea -- ven
  Who is God and Lord of __ all,
  With the poor and mean and lowly
  Lived on earth our Sa -- vior holy.
}

womenWordsTwoR = \lyricmode {
  And His shel -- ter was a sta -- ble
  And His crad -- dle was a __ stall.
}

womenWordsFive = \lyricmode {
  \set stanza = "5."
  And our eyes at last shall see Him
  Through His own re -- dee -- ming love,
  And He leads His chil -- dren on
  To the place where He is gone.
}

womenWordsFiveR = \lyricmode {
  For that child, so dear and gen -- tle
  Is our Lord in hea -- "ven a" -- bove;
}  

womenWordsSix = \lyricmode {
  \set stanza = "6."
  Not in that poor low -- ly sta -- ble,
  With the o -- xen stan -- ding by,
  Where like stars His chil -- dren crowned
  All in white shall wait a -- round. 
}

womenWordsSixR = \lyricmode {
  We shall see Him; but in hea -- ven,
  Set at God's right hand on high;  
}

sopMusic = \relative c' {
  \repeat volta 2 { 
   d4 fis g4. g8 g([ fis]) g([ a]) a4 g 
   g h d4. h8 h([ a]) g([ fis]) g2 
  }
  e'4 e d4. g,8 c4 c h2 
  e4 e d4. h8 h([ a]) g([ fis]) g2
  \bar "||"
}

altMusic = \relative c' {
  d4 fis d d cis cis d8([ c]) h4
  d4 g d d e d d2
  e8([ fis]) g([ a]) d,4 d e fis g( fis)
  e8([ fis]) g([ a]) d,([ fis]) g([ g]) e4 d d2
}

tenorMusic = \relative c' {
  h4 c d h a g fis g h d a h8([ d]) d([ c]) h([ a]) h2
  g4 c h h c d d2 c4 c h8([ c]) d([ d]) d([ c]) h([ a]) h2
}

bassMusic =  \relative c' {
  h4 a h g e a, d g, h' g fis g c, d g2
  c,8([ d]) e([ fis]) g4 h a d, g2
  c,8([ d]) e([ fis]) g([ a]) h([ g]) c,4 d <g g,>2 
}

womenMusic = \relative c'' {
  \repeat volta 2 {
   d4. d8 h([ a]) g4 e'4. e8 d([ c]) h4
   d4. d8 h([ a]) g4 c4. c8 h2
  }
  c8([ d]) e4 fis g e fis d2
  c8([ d]) e4 fis g c,4. d8 h2
}

menMusic = \relative c' {
  \repeat volta 2 { 
   d4 fis g4. g8 g([ fis]) g([ a]) a4 g 
   g h d4. h8 h([ a]) g([ fis]) g2 
  }
  e'4 e d4. g,8 c4 c h2 
  e4 e d4. h8 h([ a]) g([ fis]) g2
  \bar "|."
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsOneR }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsTwoR }
     \addlyrics { \womenWordsFive }
     \addlyrics { \womenWordsFiveR }
     %\addlyrics { \womenWordsSix }
     %\addlyrics { \womenWordsSixR }
     \new Voice { \voiceTwo \global \altMusic }   
     %\addlyrics { \womenWordsFour }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

myScoreTwo = \new Score <<
   \set Score.currentBarNumber = #9
   %\bar ""
   \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \womenMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWordsSix }
     \addlyrics { \womenWordsSixR }
     %\new Voice { \global \voiceTwo \altMusic }  
     %\addlyrics { \sopWordsThree }
    >>
       
    \new Staff <<
     %\clef "G_8"
     \new Voice { \global \menMusic }   
     %\addlyrics { \tenWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

\score {
  \myScoreTwo
  \layout { indent = 0\cm }
}

midiOutput = \midi {
  \tempo 4 = 63
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \myScoreTwo
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \womenMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \menMusic }
  \midi { \midiOutput }
}